unit Borland.Examples.WebControlLibrary;

interface

{$REGION 'Uses'}
uses System.IO,
     System.Web,
     System.Drawing,
     System.Collections,
     System.Web.UI,
     System.Web.UI.Design,
     System.Web.UI.WebControls,
     System.ComponentModel,
     System.ComponentModel.Design;
{$ENDREGION}

type
	/// <summary>
	/// Summary description for StateList.
	/// Simple control that renders a list of US State Names and codes.
	/// </summary>
  StateList = class;
  [ToolboxData('<{0}:StateList runat=server></{0}:StateList>')]
  [ToolboxBitmap( typeof( StateList), 'Borland.Examples.WebControlLibrary.StateList.bmp')]
  StateList = class(System.Web.UI.WebControls.DropDownList)
  strict private
    procedure PopulateStateSelector;
  strict protected
    function get_IsDesignTime: Boolean; virtual;
    property IsDesignTime: Boolean read get_IsDesignTime;

    procedure OnInit(e: EventArgs); override;
    procedure RenderContents(writer: HtmlTextWriter); override;
  public
  published
  end;

  { namespace + classname.bmp will give your webcontrol an icon in the IDE }
  {$R 'Borland.Examples.WebControlLibrary.StateList.bmp'}

  arrayOfObject = array of System.Object;

const
    arrayStates: array[0..50, 0..1] of string = (
								 ('AL', 'ALABAMA'),
								 ('AK', 'ALASKA'),
								 ('AZ', 'ARIZONA'),
								 ('AR', 'ARKANSAS'),
								 ('CA', 'CALIFORNIA'),
								 ('CO', 'COLORADO'),
								 ('CT', 'CONNECTICUT'),
								 ('DE', 'DELAWARE'),
								 ('DC', 'DISTRICT OF COLUMBIA'),
								 ('FL', 'FLORIDA'),
								 ('GA', 'GEORGIA'),
								 ('HI', 'HAWAII'),
								 ('ID', 'IDAHO'),
								 ('IL', 'ILLINOIS'),
								 ('IN', 'INDIANA'),
								 ('IA', 'IOWA'),
								 ('KS', 'KANSAS'),
								 ('KY', 'KENTUCKY'),
								 ('LA', 'LOUISIANA'),
								 ('ME', 'MAINE'),
								 ('MD', 'MARYLAND'),
								 ('MA', 'MASSACHUSETTS'),
								 ('MI', 'MICHIGAN'),
								 ('MN', 'MINNESOTA'),
								 ('MS', 'MISSISSIPPI'),
								 ('MO', 'MISSOURI'),
								 ('MT', 'MONTANA'),
								 ('NE', 'NEBRASKA'),
								 ('NV', 'NEVADA'),
								 ('NH', 'NEW HAMPSHIRE'),
								 ('NJ', 'NEW JERSEY'),
								 ('NM', 'NEW MEXICO'),
								 ('NY', 'NEW YORK'),
								 ('NC', 'NORTH CAROLINA'),
								 ('ND', 'NORTH DAKOTA'),
								 ('OH', 'OHIO'),
								 ('OK', 'OKLAHOMA'),
								 ('OR', 'OREGON'),
								 ('PA', 'PENNSYLVANIA'),
								 ('RI', 'RHODE ISLAND'),
								 ('SC', 'SOUTH CAROLINA'),
								 ('SD', 'SOUTH DAKOTA'),
								 ('TN', 'TENNESSEE'),
								 ('TX', 'TEXAS'),
								 ('UT', 'UTAH'),
								 ('VT', 'VERMONT'),
								 ('VA', 'VIRGINIA'),
								 ('WA', 'WASHINGTON'),
								 ('WV', 'WEST VIRGINIA'),
								 ('WI', 'WISCONSIN'),
								 ('WY', 'WYOMING') );

implementation

{ StateList }

/// <summary>
/// Detect design time
/// </summary>
function StateList.get_IsDesignTime: Boolean;
begin
  result := (Context = nil);
end;

/// <summary>
/// Override to init data
/// </summary>
procedure StateList.OnInit(e: EventArgs);
begin
  inherited OnInit(e);

  { populate dropdownlist }
  if (not IsDesignTime) then
    PopulateStateSelector;
end;

/// <summary>
/// Populate dropdownlist with US State list
/// </summary>
procedure StateList.PopulateStateSelector;
var
  liSelOneListItem: ListItem;
  i: Integer;
begin
  if (self.Items.Count > 0) then
    exit;

  { add initial "Select One" entry first }
  liSelOneListItem := ListItem.Create('Select One', '-1');
  liSelOneListItem.Selected := true;
  Items.Add(liSelOneListItem);

  { load states }
  for i := Low(arrayStates) to High(arrayStates) do
    self.Items.Add( ListItem.Create(arrayStates[i, 1], arrayStates[i, 0]) );

end;

/// <summary>
/// Override to render contents of dropdownlist
/// </summary>
procedure StateList.RenderContents(writer: HtmlTextWriter);
var
  liItem: ListItem;
  itemsEnum: IEnumerator;
begin
  itemsEnum := self.Items.GetEnumerator;

  { no foreach? no problem, get an Enumerator! }
  while (itemsEnum.MoveNext) do
  begin
    liItem := ListItem(itemsEnum.Current);

    writer.WriteBeginTag('option');
    if (liItem.Selected) then
      writer.WriteAttribute('selected', 'selected', false);

    if (liItem.Attributes.Count > 0) then
      liItem.Attributes.Render(writer);

    writer.WriteAttribute('value', liItem.Value.ToString());
    writer.Write(HtmlTextWriter.TagRightChar);
    writer.Write(liItem.Text);
    writer.WriteEndTag('option');
    writer.WriteLine();
  end;
end;

end.
